/*
 * Soft:        lvsgsp is simple connection tracking program for LVS
 *              <www.linuxvirtualserver.org>. It sum the global connections
 *              of a virtual server (ActiveConnection and InActiveConnection).
 *              Finaly it display the result to the stdout to be used with
 *              monitoring tools such as MRTG <www.mrtg.org>.
 *
 * Version:     $Id: main.h,v 0.0.4 2001/10/05 14:54:23 acassen Exp $
 *
 * Author:      Alexandre Cassen, <acassen@linux-vs.org>
 *
 *              This program is distributed in the hope that it will be useful,
 *              but WITHOUT ANY WARRANTY; without even the implied warranty of
 *              MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *              See the GNU General Public License for more details.
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 */
#ifndef _MAIN_H
#define _MAIN_H

/* global includes */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <arpa/inet.h>

/* local defs */
#ifdef KERNEL_2_2
  #define VS_PROC_FILE "/proc/net/ip_masq/vs"
#else
  #define VS_PROC_FILE "/proc/net/ip_vs"
#endif

/* Build version */
#define PROG    "lvsgsp"
#define VERSION "0.0.4 (05/10, 2001)"
#define AUTHOR  "Alexandre Cassen"

/* data structure */
typedef struct {
  uint32_t ipaddr;
  uint16_t port;
  uint32_t rsip;
  uint16_t rsport;
  int activeconns;
  int inactconns;
  int vsfill;
  int fwmark;
} vserver;

#endif
