#!/bin/bash
# LVS daily graph generation
#
# -- 03/10/2001
# Alexandre Cassen

RRDTOOL="/usr/local/bin/rrdtool"
DB="/home/httpd/rrdtool/$1.rrd"
OUTPUT="/home/httpd/html/$1-daily.gif"
LVSGSP="/usr/local/bin/lvsgsp"

# Fetch connection informations
TMP=`$LVSGSP -v 192.168.0.9 8080 -r 192.168.6.2 $2`
WWW1=`echo $TMP | cut -d' ' -f1`
TMP=`$LVSGSP -v 192.168.0.9 8080 -r 192.168.6.3 $2`
WWW2=`echo $TMP | cut -d' ' -f1`
TMP=`$LVSGSP -v 192.168.0.9 8080 -r 192.168.6.4 $2`
WWW3=`echo $TMP | cut -d' ' -f1`
TIME=`date +%T`

# update the database
$RRDTOOL update $DB N:$WWW1:$WWW2:$WWW3

# generate output graph
$RRDTOOL graph $OUTPUT --start -86400 \
	-w 550 -h 150 \
	-v "Connection Number" \
	-t "LVS realserver actives connections tracking : Daily report" \
	--alt-autoscale-max \
	COMMENT:"Current actives connections - $TIME\n" \
	DEF:web1=$DB:www1:AVERAGE \
	DEF:web2=$DB:www2:AVERAGE \
	DEF:web3=$DB:www3:AVERAGE \
	LINE1:web1#FF0000:"Webserver 192.168.6.2" \
	LINE1:web2#0000FF:"Webserver 192.168.6.3" \
	LINE1:web3#555555:"Webserver 192.168.6.4"
