#!/bin/bash
# LVS daily graph generation
#
# -- 03/10/2001
# Alexandre Cassen

RRDTOOL="/usr/local/bin/rrdtool"
DB="/home/httpd/rrdtool/$1.rrd"
OUTPUT="/home/httpd/html/$1-weekly.gif"

# generate output graph
$RRDTOOL graph $OUTPUT --start -604800 \
	-w 550 -h 150 \
	-v "Connection Number" \
	-t "LVS realserver actives connections tracking : Weekly report" \
	--alt-autoscale-max \
	COMMENT:"Current actives connections - $TIME\n" \
	DEF:web1=$DB:www1:AVERAGE \
	DEF:web2=$DB:www2:AVERAGE \
	DEF:web3=$DB:www3:AVERAGE \
	LINE1:web1#FF0000:"Webserver 192.168.6.2" \
	LINE1:web2#0000FF:"Webserver 192.168.6.3" \
	LINE1:web3#555555:"Webserver 192.168.6.4"
